package org.beast.propagation.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import lombok.extern.slf4j.Slf4j;
import org.beast.propagation.Propagation;
import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;

import java.io.IOException;
import java.util.*;

@Slf4j
public class PropagationRetryableFeignBlockingLoadBalancerClient extends FeignBlockingLoadBalancerClient {

    private final BeanFactory beanFactory;

    private CurrentContext currentContext;

    private Propagation propagation;

    //传播
    static final Propagation.Setter<Map<String, Collection<String>>> SETTER = new Propagation.Setter<Map<String, Collection<String>>>() {
        @Override
        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                List<String> values = new ArrayList<>();
                if (value != null) {
                    values.add(value);
                }
                carrier.put(key, values);
            };
        }
    };

    public PropagationRetryableFeignBlockingLoadBalancerClient(
            Client delegate,
            LoadBalancerClient loadBalancerClient,
            LoadBalancerProperties properties,
            LoadBalancerClientFactory loadBalancerClientFactory,
            BeanFactory beanFactory
    ) {
        super(delegate, loadBalancerClient, properties, loadBalancerClientFactory);
        this.beanFactory = beanFactory;
    }

//    private final BeanFactory beanFactory;

//    public PropagationLoadBalancerFeignClient(
//            Client delegate, CachingSpringLoadBalancerFactory lbClientFactory,
//            SpringClientFactory clientFactory,
//            BeanFactory beanFactory) {
//        super(delegate, lbClientFactory, clientFactory);
//        this.beanFactory = beanFactory;
//    }


    @Override
    public Response execute(Request request, Request.Options options) throws IOException {

        Response response = null;
        Map<String, Collection<String>> headers = new HashMap<>(request.headers());
        Context context = currentContext.get();
        log.debug("execute context: {}", context);
        Context.Injector<Map<String, Collection<String>>> injector = propagation.injector(SETTER);
        try {
            injector.inject(context, headers);
            request = modifiedRequest(request, headers);
            if (delegateIsLoadBalancer()) {
                response = getDelegate().execute(request, options);
            } else {
                response = super.execute(request, options);
            }

            return response;
        } catch (Exception e) {
            if (e instanceof IOException) {
                
            }
            //记录跟踪
            throw e;
        } finally {

        }
    }

    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        Request.HttpMethod method = request.httpMethod();
        String url = request.url();
        return Request.create(method, url, headers, Request.Body.create(request.body(), request.charset()),request.requestTemplate());
    }

    private boolean delegateIsLoadBalancer() {
        return getDelegate() instanceof RetryableFeignBlockingLoadBalancerClient;
    }

    private CurrentContext currentContext() {
        if (currentContext == null) {
            currentContext = beanFactory.getBean(CurrentContext.class);
        }
        return currentContext;
    }

    private Propagation propagation() {
        if (propagation == null) {
            propagation = beanFactory.getBean(Propagation.class);
        }
        return propagation;
    }
}
