package org.beast.propagation.instrument.web.client.feign;

import feign.Client;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.util.ClassUtils;

import java.lang.reflect.Field;

@Slf4j
public class PropagationFeignObjectWrapper {
//    private static final boolean ribbonPresent;
    private static final boolean loadBalancerPresent;

    public static final String EXCEPTION_WARNING = "Exception occurred while trying to access the delegate's field. Will fallback to default instrumentation mechanism, which means that the delegate might not be instrumented";

    private static final String DELEGATE = "delegate";

    static {
//        ribbonPresent = ClassUtils.isPresent(
//                "org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient",
//                null)
//                && ClassUtils.isPresent(
//                "org.springframework.cloud.netflix.ribbon.SpringClientFactory",
//                null);
        loadBalancerPresent = ClassUtils.
                isPresent("org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient", (ClassLoader)null)
                && ClassUtils.isPresent("org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient", (ClassLoader)null)
                && ClassUtils.isPresent("org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory", (ClassLoader)null);

    }

    private final BeanFactory beanFactory;

    private Object loadBalancerClient;

    private LoadBalancerProperties loadBalancerProperties;

    private Object loadBalancerRetryFactory;

    private Object loadBalancerClientFactory;

    public PropagationFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }


    public Object wrap(Object bean){
        if (bean instanceof Client && !(bean instanceof PropagationFeignClient)) {

            if (loadBalancerPresent && bean instanceof FeignBlockingLoadBalancerClient
                 && !(bean instanceof PropagationFeignBlockingLoadBalancerClient)) {
                return instrumentedFeignLoadBalancerClient(bean);
            }

            if (loadBalancerPresent && bean instanceof RetryableFeignBlockingLoadBalancerClient
                && !(bean instanceof PropagationRetryableFeignBlockingLoadBalancerClient)) {
                return instrumentedRetryableFeignLoadBalancerClient(bean);
            }
            return new LazyPropagationFeignClient(this.beanFactory, (Client) bean);
        }
        return bean;
    }

    private Object instrumentedFeignLoadBalancerClient(Object bean) {
        if (AopUtils.getTargetClass(bean).equals(FeignBlockingLoadBalancerClient.class)) {
            FeignBlockingLoadBalancerClient client = ProxyUtils.getTargetObject(bean);
            return new PropagationFeignBlockingLoadBalancerClient(
                    (Client) new PropagationFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()),
                    (LoadBalancerClient) loadBalancerClient(), loadBalancerProperties(),
                    (LoadBalancerClientFactory) loadBalancerClientFactory(), this.beanFactory
            );
        } else {
            FeignBlockingLoadBalancerClient client = ProxyUtils.getTargetObject(bean);
            try {
                Field delegate = FeignBlockingLoadBalancerClient.class.getDeclaredField(DELEGATE);
                delegate.setAccessible(true);
                delegate.set(client, new PropagationFeignObjectWrapper(this.beanFactory));
            } catch (NoSuchFieldException | IllegalArgumentException | IllegalAccessException | SecurityException e) {
                log.warn(EXCEPTION_WARNING, e);
            }
            return new PropagationFeignBlockingLoadBalancerClient(
                client, (LoadBalancerClient) loadBalancerClient(),
                loadBalancerProperties(),
                (LoadBalancerClientFactory) loadBalancerClientFactory(),
                this.beanFactory
            );
        }
    }

    private Object instrumentedRetryableFeignLoadBalancerClient(Object bean) {
        if (AopUtils.getTargetClass(bean).equals(PropagationRetryableFeignBlockingLoadBalancerClient.class)) {
            FeignBlockingLoadBalancerClient client = ProxyUtils.getTargetObject(bean);
            return new PropagationRetryableFeignBlockingLoadBalancerClient(
                    (Client) new PropagationFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()),
                    (LoadBalancerClient) loadBalancerClient(), loadBalancerProperties(),
                    (LoadBalancerClientFactory) loadBalancerClientFactory(), this.beanFactory
            );
        } else {
            FeignBlockingLoadBalancerClient client = ProxyUtils.getTargetObject(bean);
            try {
                Field delegate = FeignBlockingLoadBalancerClient.class.getDeclaredField(DELEGATE);
                delegate.setAccessible(true);
                delegate.set(client, new PropagationFeignObjectWrapper(this.beanFactory));
            } catch (NoSuchFieldException | IllegalArgumentException | IllegalAccessException | SecurityException e) {
                log.warn(EXCEPTION_WARNING, e);
            }
            return new PropagationRetryableFeignBlockingLoadBalancerClient(
                    client, (LoadBalancerClient) loadBalancerClient(),
                    loadBalancerProperties(),
                    (LoadBalancerClientFactory) loadBalancerClientFactory(),
                    this.beanFactory
            );
        }
    }
//    private Object instrumentedRetryableFeignLoadBalancerClient(Object bean) {
//        if (AopUtils.getTargetClass(bean).equals(RetryableFeignBlockingLoadBalancerClient.class)) {
//            RetryableFeignBlockingLoadBalancerClient client = ProxyUtils.getTargetObject(bean);
//            return new TraceRetryableFeignBlockingLoadBalancerClient(
//                client
//            );
//        } else {
//            return new TraceRetryableFeignBlockingLoadBalancerClient(
//                client
//            );
//        }
//    }

    private Object loadBalancerClient() {
        if (loadBalancerClient == null) {
            loadBalancerClient = beanFactory.getBean(LoadBalancerClient.class);
        }
        return loadBalancerClient;
    }
    private LoadBalancerProperties loadBalancerProperties() {
        if (loadBalancerProperties == null) {
            loadBalancerProperties = beanFactory.getBean(LoadBalancerProperties.class);
        }
        return loadBalancerProperties;
    }

    private Object loadBalancerRetryFactory() {
        if (loadBalancerRetryFactory == null) {
            loadBalancerRetryFactory = beanFactory.getBean(LoadBalancedRetryFactory.class);
        }
        return loadBalancerRetryFactory;
    }

    private Object loadBalancerClientFactory() {
        if (loadBalancerClientFactory == null) {
            loadBalancerClientFactory = beanFactory.getBean(LoadBalancerClientFactory.class);
        }
        return loadBalancerClientFactory;
    }
//    private CachingSpringLoadBalancerFactory cachingSpringLoadBalancerFactory;


//    private CachingSpringLoadBalancerFactory factory() {
//        if (this.cachingSpringLoadBalancerFactory == null) {
//            this.cachingSpringLoadBalancerFactory = this.beanFactory
//                    .getBean(CachingSpringLoadBalancerFactory.class);
//        }
//        return this.cachingSpringLoadBalancerFactory;
//    }

}
