package org.beast.propagation.instrument.web;

import org.beast.propagation.Propagation;
import org.beast.propagation.PropagationAutoConfiguration;
import org.beast.propagation.context.CurrentContext;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@AutoConfigureAfter(PropagationAutoConfiguration.class)
public class WebFluxPropagationAutoConfiguration {


    @Bean
    public PropagationWebFilter propagationWebFilter(Propagation propagation, CurrentContext currentContext) {
        return new PropagationWebFilter(propagation, currentContext);
    }
}
