package org.beast.propagation.instrument.async;

import org.beast.propagation.context.CurrentContext;

import java.util.concurrent.Executor;

public class ContextExecutor implements Executor {

    private final Executor delegate;

    private CurrentContext currentContext;

    public ContextExecutor(CurrentContext currentContext, Executor delegate) {
        this.delegate = delegate;
        this.currentContext = currentContext;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(new ContextRunnable(currentContext, command));
    }
}
