package org.beast.propagation;

import org.beast.propagation.context.CurrentContext;
import org.beast.propagation.context.ThreadLocalCurrentContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
//@EnableConfigurationProperties
public class PropagationAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public CurrentContext currentContext() {
        return ThreadLocalCurrentContext.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public Propagation propagation() {
        return new DefaultPropagation(List.of("X-Sequences"));
    }

}
