/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.beast.propagation.Propagation;
import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagationFeignClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(PropagationFeignClient.class);
    static final Propagation.Setter<Map<String, Collection<String>>> SETTER = new Propagation.Setter<Map<String, Collection<String>>>(){

        @Override
        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                ArrayList<String> values = new ArrayList<String>();
                if (value != null) {
                    values.add(value);
                }
                carrier.put(key, values);
            }
        }
    };
    private final CurrentContext currentContext;
    private final Client delegate;
    private Context.Injector<Map<String, Collection<String>>> injector;

    public PropagationFeignClient(CurrentContext currentContext, Propagation propagation, Client delegate) {
        this.currentContext = currentContext;
        this.delegate = delegate;
        this.injector = propagation.injector(SETTER);
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>(request.headers());
        Context context = this.currentContext.get();
        log.debug("execute context: {}", (Object)context);
        this.injector.inject(context, headers);
        return this.delegate.execute(this.modifiedRequest(request, headers), options);
    }

    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        Request.HttpMethod method = request.httpMethod();
        String url = request.url();
        return Request.create((Request.HttpMethod)method, (String)url, headers, (Request.Body)Request.Body.create((byte[])request.body(), (Charset)request.charset()), (RequestTemplate)request.requestTemplate());
    }
}

