/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.web.client.feign;

import feign.Client;
import java.lang.reflect.Field;
import org.beast.propagation.instrument.web.client.feign.LazyPropagationFeignClient;
import org.beast.propagation.instrument.web.client.feign.PropagationFeignBlockingLoadBalancerClient;
import org.beast.propagation.instrument.web.client.feign.PropagationFeignClient;
import org.beast.propagation.instrument.web.client.feign.PropagationRetryableFeignBlockingLoadBalancerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.util.ClassUtils;

public class PropagationFeignObjectWrapper {
    private static final Logger log = LoggerFactory.getLogger(PropagationFeignObjectWrapper.class);
    private static final boolean loadBalancerPresent = ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient", (ClassLoader)null) && ClassUtils.isPresent((String)"org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient", (ClassLoader)null) && ClassUtils.isPresent((String)"org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory", (ClassLoader)null);
    public static final String EXCEPTION_WARNING = "Exception occurred while trying to access the delegate's field. Will fallback to default instrumentation mechanism, which means that the delegate might not be instrumented";
    private static final String DELEGATE = "delegate";
    private final BeanFactory beanFactory;
    private Object loadBalancerClient;
    private LoadBalancerProperties loadBalancerProperties;
    private Object loadBalancerRetryFactory;
    private Object loadBalancerClientFactory;

    public PropagationFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof PropagationFeignClient)) {
            if (loadBalancerPresent && bean instanceof FeignBlockingLoadBalancerClient && !(bean instanceof PropagationFeignBlockingLoadBalancerClient)) {
                return this.instrumentedFeignLoadBalancerClient(bean);
            }
            if (loadBalancerPresent && bean instanceof RetryableFeignBlockingLoadBalancerClient && !(bean instanceof PropagationRetryableFeignBlockingLoadBalancerClient)) {
                return this.instrumentedRetryableFeignLoadBalancerClient(bean);
            }
            return new LazyPropagationFeignClient(this.beanFactory, (Client)bean);
        }
        return bean;
    }

    private Object instrumentedFeignLoadBalancerClient(Object bean) {
        if (AopUtils.getTargetClass((Object)bean).equals(FeignBlockingLoadBalancerClient.class)) {
            FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
            return new PropagationFeignBlockingLoadBalancerClient((Client)new PropagationFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), (LoadBalancerClient)this.loadBalancerClient(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
        }
        FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
        try {
            Field delegate = FeignBlockingLoadBalancerClient.class.getDeclaredField(DELEGATE);
            delegate.setAccessible(true);
            delegate.set(client, new PropagationFeignObjectWrapper(this.beanFactory));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn(EXCEPTION_WARNING, (Throwable)e);
        }
        return new PropagationFeignBlockingLoadBalancerClient((Client)client, (LoadBalancerClient)this.loadBalancerClient(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
    }

    private Object instrumentedRetryableFeignLoadBalancerClient(Object bean) {
        if (AopUtils.getTargetClass((Object)bean).equals(PropagationRetryableFeignBlockingLoadBalancerClient.class)) {
            FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
            return new PropagationRetryableFeignBlockingLoadBalancerClient((Client)new PropagationFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), (LoadBalancerClient)this.loadBalancerClient(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
        }
        FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
        try {
            Field delegate = FeignBlockingLoadBalancerClient.class.getDeclaredField(DELEGATE);
            delegate.setAccessible(true);
            delegate.set(client, new PropagationFeignObjectWrapper(this.beanFactory));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn(EXCEPTION_WARNING, (Throwable)e);
        }
        return new PropagationRetryableFeignBlockingLoadBalancerClient((Client)client, (LoadBalancerClient)this.loadBalancerClient(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
    }

    private Object loadBalancerClient() {
        if (this.loadBalancerClient == null) {
            this.loadBalancerClient = this.beanFactory.getBean(LoadBalancerClient.class);
        }
        return this.loadBalancerClient;
    }

    private LoadBalancerProperties loadBalancerProperties() {
        if (this.loadBalancerProperties == null) {
            this.loadBalancerProperties = (LoadBalancerProperties)this.beanFactory.getBean(LoadBalancerProperties.class);
        }
        return this.loadBalancerProperties;
    }

    private Object loadBalancerRetryFactory() {
        if (this.loadBalancerRetryFactory == null) {
            this.loadBalancerRetryFactory = this.beanFactory.getBean(LoadBalancedRetryFactory.class);
        }
        return this.loadBalancerRetryFactory;
    }

    private Object loadBalancerClientFactory() {
        if (this.loadBalancerClientFactory == null) {
            this.loadBalancerClientFactory = this.beanFactory.getBean(LoadBalancerClientFactory.class);
        }
        return this.loadBalancerClientFactory;
    }
}

