/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.web;

import org.beast.propagation.Propagation;
import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;

public class PropagationWebFilter
implements WebFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(PropagationWebFilter.class);
    private Context.Extractor<HttpHeaders> extractor;
    private CurrentContext currentContext;

    public PropagationWebFilter(Propagation propagation, CurrentContext currentContext) {
        this.extractor = propagation.extractor(new Propagation.Getter<HttpHeaders>(){

            @Override
            public String get(HttpHeaders carrier, String key) {
                return carrier.getFirst(key);
            }
        });
        this.currentContext = currentContext;
    }

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, @NonNull WebFilterChain chain) {
        return new WebFilterMonoOperator((Mono<? extends Void>)chain.filter(exchange), exchange);
    }

    public int getOrder() {
        return -2147483644;
    }

    private class WebFilterMonoOperator
    extends MonoOperator<Void, Void> {
        final ServerWebExchange exchange;

        protected WebFilterMonoOperator(Mono<? extends Void> source, ServerWebExchange exchange) {
            super(source);
            this.exchange = exchange;
        }

        public void subscribe(@NonNull CoreSubscriber<? super Void> subscriber) {
            reactor.util.context.Context context = subscriber.currentContext();
            this.source.subscribe((CoreSubscriber)new WebFilterSubscriber(subscriber, context, this.findOrCreateScope(context)));
        }

        private CurrentContext.Scope findOrCreateScope(reactor.util.context.Context c) {
            CurrentContext.Scope scope;
            Class<CurrentContext.Scope> key = CurrentContext.Scope.class;
            if (c.hasKey(key)) {
                scope = (CurrentContext.Scope)c.get(key);
            } else {
                ServerHttpRequest request = this.exchange.getRequest();
                Context context = PropagationWebFilter.this.extractor.extract(request.getHeaders());
                scope = PropagationWebFilter.this.currentContext.newScope(context);
            }
            return scope;
        }

        final class WebFilterSubscriber
        implements CoreSubscriber<Void> {
            final CoreSubscriber<? super Void> actual;
            final reactor.util.context.Context context;
            final CurrentContext.Scope scope;

            public WebFilterSubscriber(CoreSubscriber<? super Void> actual, reactor.util.context.Context context, CurrentContext.Scope scope) {
                this.actual = actual;
                this.context = context.put(CurrentContext.Scope.class, (Object)scope);
                this.scope = scope;
            }

            public void onSubscribe(Subscription subscription) {
                this.actual.onSubscribe(subscription);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable t) {
                this.terminate();
                this.actual.onError(t);
            }

            public void onComplete() {
                this.terminate();
                this.actual.onComplete();
            }

            public reactor.util.context.Context currentContext() {
                return this.context;
            }

            private void terminate() {
                this.scope.close();
            }
        }
    }
}

