/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.reactor;

import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;
import org.beast.propagation.instrument.reactor.PassingSubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;

public class ScopePassingSubscriber<T>
implements PassingSubscription<T>,
Scannable {
    private final Subscriber<? super T> subscriber;
    private final reactor.util.context.Context reactorContext;
    private final CurrentContext currentContext;
    private final Context context;
    private Subscription s;

    public ScopePassingSubscriber(Subscriber<? super T> subscriber, reactor.util.context.Context ctx, CurrentContext currentContext, Context context) {
        this.subscriber = subscriber;
        this.reactorContext = ctx != null ? ctx : reactor.util.context.Context.empty();
        this.currentContext = currentContext;
        this.context = context;
    }

    public void onNext(T t) {
        try (CurrentContext.Scope scope = this.currentContext.maybeScope(this.context);){
            this.subscriber.onNext(t);
        }
    }

    public void onError(Throwable throwable) {
        try (CurrentContext.Scope scope = this.currentContext.maybeScope(this.context);){
            this.subscriber.onError(throwable);
        }
    }

    public void onComplete() {
        try (CurrentContext.Scope scope = this.currentContext.maybeScope(this.context);){
            this.subscriber.onComplete();
        }
    }

    public void request(long l) {
        try (CurrentContext.Scope scope = this.currentContext.maybeScope(this.context);){
            this.s.request(l);
        }
    }

    public void cancel() {
        try (CurrentContext.Scope scope = this.currentContext.maybeScope(this.context);){
            this.s.cancel();
        }
    }

    public void onSubscribe(Subscription s) {
        this.s = s;
        try (CurrentContext.Scope scope = this.currentContext.maybeScope(this.context);){
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        return key == Scannable.Attr.ACTUAL ? this.subscriber : null;
    }

    public reactor.util.context.Context currentContext() {
        return this.reactorContext;
    }
}

