/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.reactor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;
import org.beast.propagation.instrument.reactor.LazyPassingSubscriber;
import org.beast.propagation.instrument.reactor.PassingSubscriptionProvider;
import org.beast.propagation.instrument.reactor.ScopePassingSubscriber;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;

public class Reactors {
    private static final Logger log = LoggerFactory.getLogger(Reactors.class);
    private static Map<BeanFactory, CurrentContext> CACHE = new ConcurrentHashMap<BeanFactory, CurrentContext>();

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> scopePassingSpanOperator(BeanFactory beanFactory) {
        BooleanSupplier isActive = beanFactory instanceof ConfigurableApplicationContext ? () -> ((ConfigurableApplicationContext)((ConfigurableApplicationContext)beanFactory)).isActive() : () -> true;
        return Operators.liftPublisher((p, sub) -> {
            if (p instanceof Fuseable.ScalarCallable) {
                return sub;
            }
            Scannable scannable = Scannable.from((Object)p);
            if (isActive.getAsBoolean()) {
                if (log.isTraceEnabled()) {
                    log.trace("Spring Context [{}}] already refreshed. Creating a scope passing propagation subscriber with Reactor Context [{}] and name [{}]", new Object[]{beanFactory, sub.currentContext(), scannable.name()});
                }
                return Reactors.scopePassingSpanSubscription(beanFactory, sub);
            }
            if (log.isTraceEnabled()) {
                log.trace("Spring Context [" + beanFactory + "] is not yet refreshed, falling back to lazy span subscriber. Reactor Context is [" + sub.currentContext() + "] and name is [" + scannable.name() + "]");
            }
            return new LazyPassingSubscriber(Reactors.lazyScopePassingSubscription(beanFactory, scannable, sub));
        });
    }

    static <T> PassingSubscriptionProvider<T> lazyScopePassingSubscription(BeanFactory beanFactory, Scannable scannable, CoreSubscriber<? super T> sub) {
        return new PassingSubscriptionProvider<T>(beanFactory, sub, sub.currentContext());
    }

    static <T> CoreSubscriber<? super T> scopePassingSpanSubscription(BeanFactory beanFactory, CoreSubscriber<? super T> sub) {
        Context root;
        CurrentContext currentContext = CACHE.computeIfAbsent(beanFactory, beanFactory1 -> (CurrentContext)beanFactory1.getBean(CurrentContext.class));
        reactor.util.context.Context context = sub.currentContext();
        Context context2 = root = context.hasKey(Context.class) ? (Context)context.get(Context.class) : currentContext.get();
        if (root != null) {
            return new ScopePassingSubscriber<T>(sub, context, currentContext, root);
        }
        return sub;
    }
}

