/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.reactor;

import java.util.function.Supplier;
import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;
import org.beast.propagation.instrument.reactor.PassingSubscription;
import org.beast.propagation.instrument.reactor.ScopePassingSubscriber;
import org.reactivestreams.Subscriber;
import org.springframework.beans.factory.BeanFactory;

public class PassingSubscriptionProvider<T>
implements Supplier<PassingSubscription<T>> {
    final BeanFactory beanFactory;
    final Subscriber<? super T> subscriber;
    final reactor.util.context.Context reactorContext;
    private volatile CurrentContext currentContext;

    public PassingSubscriptionProvider(BeanFactory beanFactory, Subscriber<? super T> subscriber, reactor.util.context.Context ctx) {
        this.beanFactory = beanFactory;
        this.subscriber = subscriber;
        this.reactorContext = ctx != null ? ctx : reactor.util.context.Context.empty();
    }

    @Override
    public PassingSubscription<T> get() {
        return this.newCoreSubscriber();
    }

    PassingSubscription<T> newCoreSubscriber() {
        Context context = this.reactorContext.hasKey(Context.class) ? (Context)this.reactorContext.get(Context.class) : this.currentContext().get();
        return new ScopePassingSubscriber<T>(this.subscriber, this.reactorContext, this.currentContext, context);
    }

    private CurrentContext currentContext() {
        if (this.currentContext == null) {
            this.currentContext = (CurrentContext)this.beanFactory.getBean(CurrentContext.class);
        }
        return this.currentContext;
    }
}

