/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.context;

import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;

public class ThreadLocalCurrentContext
extends CurrentContext {
    private final ThreadLocal<Context> local;
    private static final ThreadLocal<Context> DEFAULT = new ThreadLocal();
    private static final InheritableThreadLocal<Context> INHERITABLE = new InheritableThreadLocal();

    public ThreadLocalCurrentContext(ThreadLocal<Context> local) {
        this.local = local;
    }

    @Override
    public Context get() {
        return this.local.get();
    }

    @Override
    public CurrentContext.Scope newScope(Context current) {
        final Context previous = this.local.get();
        this.local.set(current);
        class DefaultCurrentContextScope
        implements CurrentContext.Scope {
            DefaultCurrentContextScope() {
            }

            @Override
            public void close() throws RuntimeException {
                ThreadLocalCurrentContext.this.local.set(previous);
            }
        }
        return new DefaultCurrentContextScope();
    }

    public static CurrentContext create() {
        return new ThreadLocalCurrentContext(DEFAULT);
    }

    public static CurrentContext createInheritable() {
        return new ThreadLocalCurrentContext(INHERITABLE);
    }
}

