/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation;

import java.util.List;
import org.beast.propagation.Propagation;
import org.beast.propagation.context.Context;

public class DefaultPropagation
implements Propagation {
    private final List<String> keys;

    public DefaultPropagation(List<String> keys) {
        this.keys = keys;
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    @Override
    public <C> Context.Injector<C> injector(Propagation.Setter<C> setter) {
        return new InnerInjector<C>(this, setter);
    }

    @Override
    public <C> Context.Extractor<C> extractor(Propagation.Getter<C> getter) {
        return new InnerExtractor<C>(this, getter);
    }

    static final class InnerInjector<C>
    implements Context.Injector<C> {
        private Propagation propagation;
        private Propagation.Setter<C> setter;

        public InnerInjector(Propagation propagation, Propagation.Setter<C> setter) {
            this.propagation = propagation;
            this.setter = setter;
        }

        @Override
        public <T> void inject(Context context, C carrier) {
            if (context != null) {
                for (String key : this.propagation.keys()) {
                    this.setter.put(carrier, key, (String)context.get(key));
                }
            }
        }
    }

    static final class InnerExtractor<C>
    implements Context.Extractor<C> {
        private Propagation propagation;
        private Propagation.Getter<C> getter;

        public InnerExtractor(Propagation propagation, Propagation.Getter<C> getter) {
            this.propagation = propagation;
            this.getter = getter;
        }

        @Override
        public Context extract(C carrier) {
            Context context = new Context();
            for (String key : this.propagation.keys()) {
                context.put(key, this.getter.get(carrier, key));
            }
            return context;
        }
    }
}

