/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.beast.propagation.Propagation;
import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;

public class PropagationRetryableFeignBlockingLoadBalancerClient
extends FeignBlockingLoadBalancerClient {
    private static final Logger log = LoggerFactory.getLogger(PropagationRetryableFeignBlockingLoadBalancerClient.class);
    private final BeanFactory beanFactory;
    private CurrentContext currentContext;
    private Propagation propagation;
    static final Propagation.Setter<Map<String, Collection<String>>> SETTER = new Propagation.Setter<Map<String, Collection<String>>>(){

        @Override
        public void put(Map<String, Collection<String>> carrier, String key, String value) {
            if (!carrier.containsKey(key)) {
                ArrayList<String> values = new ArrayList<String>();
                if (value != null) {
                    values.add(value);
                }
                carrier.put(key, values);
            }
        }
    };

    public PropagationRetryableFeignBlockingLoadBalancerClient(Client delegate, LoadBalancerClient loadBalancerClient, LoadBalancerProperties properties, LoadBalancerClientFactory loadBalancerClientFactory, BeanFactory beanFactory) {
        super(delegate, loadBalancerClient, properties, loadBalancerClientFactory);
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        Response response = null;
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>(request.headers());
        Context context = this.currentContext.get();
        log.debug("execute context: {}", (Object)context);
        Context.Injector<Map<String, Collection<String>>> injector = this.propagation.injector(SETTER);
        try {
            injector.inject(context, headers);
            request = this.modifiedRequest(request, headers);
            response = this.delegateIsLoadBalancer() ? this.getDelegate().execute(request, options) : super.execute(request, options);
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                // empty if block
            }
            throw e;
        }
    }

    private Request modifiedRequest(Request request, Map<String, Collection<String>> headers) {
        Request.HttpMethod method = request.httpMethod();
        String url = request.url();
        return Request.create((Request.HttpMethod)method, (String)url, headers, (Request.Body)Request.Body.create((byte[])request.body(), (Charset)request.charset()), (RequestTemplate)request.requestTemplate());
    }

    private boolean delegateIsLoadBalancer() {
        return this.getDelegate() instanceof RetryableFeignBlockingLoadBalancerClient;
    }

    private CurrentContext currentContext() {
        if (this.currentContext == null) {
            this.currentContext = (CurrentContext)this.beanFactory.getBean(CurrentContext.class);
        }
        return this.currentContext;
    }

    private Propagation propagation() {
        if (this.propagation == null) {
            this.propagation = (Propagation)this.beanFactory.getBean(Propagation.class);
        }
        return this.propagation;
    }
}

