package org.beast.propagation.shunt.loadbalancer;

import lombok.extern.slf4j.Slf4j;
import org.beast.propagation.shunt.Shunt;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration;
import org.springframework.cloud.loadbalancer.core.*;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

import java.util.Objects;


/**
 * org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration
 * 替代client configuration 实现
 */
@Slf4j
@Configuration(proxyBeanMethods = false)
@ConditionalOnDiscoveryEnabled
public class ShuntLoadBalancerClientConfiguration {

//    @Bean
//    @ConditionalOnBean(ReactiveDiscoveryClient.class)
//    @ConditionalOnMissingBean
//    public ServiceInstanceListSupplier shuntDiscoveryClientServiceInstanceListSupplier(
//            ConfigurableApplicationContext context,
//            Shunt shunt
//    ) {
//        DiscoveryClient discoveryClient = context.getBean(DiscoveryClient.class);
//
//        ServiceInstanceListSupplier baseSupplier = new DiscoveryClientServiceInstanceListSupplier(discoveryClient, context.getEnvironment());
//        baseSupplier = new ShuntPreferenceServiceInstanceListSupplier(baseSupplier, shunt);
//        return ServiceInstanceListSupplier.builder()
//                .withBase(baseSupplier)
////                .withCaching()
//                .build(context);
//    }



//    @Bean
//    @ConditionalOnMissingBean
//    public ReactorLoadBalancer<ServiceInstance> reactorShuntLoadBalancer(Environment environment,
//                                                                                   LoadBalancerClientFactory loadBalancerClientFactory) {
//        String name = environment.getProperty(LoadBalancerClientFactory.PROPERTY_NAME);
//        return new RoundRobinLoadBalancer(
//                loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name);
//    }

    @Configuration(proxyBeanMethods = false)
    @ConditionalOnBean(Shunt.class)
    @ConditionalOnBlockingDiscoveryEnabled
//    @Order(REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER + 1)
    public static class BlockingSupportConfiguration {

        //    @ConditionalOnBean(ReactiveDiscoveryClient.class)
        @Bean
        @ConditionalOnBean(DiscoveryClient.class)
        @ConditionalOnMissingBean
        public ServiceInstanceListSupplier shuntDiscoveryClientServiceInstanceListSupplier(
                ConfigurableApplicationContext context,
                Shunt shunt
        ) {
            return ServiceInstanceListSupplier.builder()
                    .withBlockingDiscoveryClient()
//                    .withCaching()
                    .with(new ShuntDelegateCreator())
                    .build(context);
        }
    }
    @Configuration(proxyBeanMethods = false)
    @ConditionalOnBean(Shunt.class)
    @ConditionalOnReactiveDiscoveryEnabled
//    @Order(REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER)
    public static class ReactiveSupportConfiguration {

        //    @ConditionalOnBean(ReactiveDiscoveryClient.class)
        @Bean
        @ConditionalOnBean(ReactiveDiscoveryClient.class)
        @ConditionalOnMissingBean
//        @Conditional(LoadBalancerClientConfiguration.DefaultConfigurationCondition.class)
        public ServiceInstanceListSupplier shuntDiscoveryClientServiceInstanceListSupplier(
                ConfigurableApplicationContext context,
                Shunt shunt
        ) {
            return ServiceInstanceListSupplier.builder()
                    .withDiscoveryClient()
//                    .withCaching()
                    .with(new ShuntDelegateCreator())
//                .withCaching()
                    .build(context);
        }
    }


    private static class ShuntDelegateCreator implements ServiceInstanceListSupplierBuilder.DelegateCreator {

        @Override
        public ServiceInstanceListSupplier apply(ConfigurableApplicationContext context,
                                                 ServiceInstanceListSupplier delegate) {
            var shuntProvider = context.getBeanProvider(Shunt.class);
            var shunt = shuntProvider.getIfAvailable();
            if (Objects.nonNull(shunt)) {
                return new ShuntPreferenceServiceInstanceListSupplier(delegate, shunt);
            }
            log.warn("Shunt not available, returning delegate without shunt.");
            return delegate;
        }
    }



}
