/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.shunt.loadbalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.beast.propagation.shunt.Shunt;
import org.beast.propagation.shunt.propagation.ShuntContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

public class ShuntPreferenceServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private static final Logger log = LoggerFactory.getLogger(ShuntPreferenceServiceInstanceListSupplier.class);
    private Shunt shunt;
    private static final String GROUP = "group";

    public ShuntPreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, Shunt shunt) {
        super(delegate);
        this.shunt = shunt;
    }

    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.getDelegate().get()).map(instances -> ShuntPreferenceServiceInstanceListSupplier.filter(this.shunt, instances));
    }

    public Flux<List<ServiceInstance>> get(Request request) {
        return this.get();
    }

    public static List<ServiceInstance> filter(Shunt shunt, List<ServiceInstance> serviceInstances) {
        ShuntContext context = shunt.currentShuntContext().get();
        List<Object> sequences = Collections.emptyList();
        if (context != null) {
            sequences = context.sequences();
        }
        ArrayList<ServiceInstance> filteredInstances = new ArrayList<ServiceInstance>();
        if (!CollectionUtils.isEmpty(sequences)) {
            for (String string : sequences) {
                for (ServiceInstance serviceInstance : serviceInstances) {
                    String group = ShuntPreferenceServiceInstanceListSupplier.group(serviceInstance);
                    if (!string.equals(group)) continue;
                    filteredInstances.add(serviceInstance);
                }
                if (filteredInstances.size() <= 0) continue;
                break;
            }
        }
        if (ObjectUtils.isEmpty(filteredInstances)) {
            for (ServiceInstance serviceInstance : serviceInstances) {
                String serverGroup = ShuntPreferenceServiceInstanceListSupplier.group(serviceInstance);
                if (!"standard".equals(serverGroup) && !Objects.isNull(serverGroup)) continue;
                filteredInstances.add(serviceInstance);
            }
        }
        log.trace("shunt sequences: {} instances: {}", sequences, filteredInstances);
        return filteredInstances;
    }

    private static String group(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null) {
            return (String)metadata.get(GROUP);
        }
        return null;
    }
}

