/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.shunt.loadbalancer;

import java.util.Objects;
import org.beast.propagation.shunt.Shunt;
import org.beast.propagation.shunt.loadbalancer.ShuntPreferenceServiceInstanceListSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplierBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
public class ShuntLoadBalancerClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ShuntLoadBalancerClientConfiguration.class);

    private static class ShuntDelegateCreator
    implements ServiceInstanceListSupplierBuilder.DelegateCreator {
        private ShuntDelegateCreator() {
        }

        public ServiceInstanceListSupplier apply(ConfigurableApplicationContext context, ServiceInstanceListSupplier delegate) {
            ObjectProvider shuntProvider = context.getBeanProvider(Shunt.class);
            Shunt shunt = (Shunt)shuntProvider.getIfAvailable();
            if (Objects.nonNull(shunt)) {
                return new ShuntPreferenceServiceInstanceListSupplier(delegate, shunt);
            }
            log.warn("Shunt not available, returning delegate without shunt.");
            return delegate;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Shunt.class})
    @ConditionalOnReactiveDiscoveryEnabled
    public static class ReactiveSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        public ServiceInstanceListSupplier shuntDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context, Shunt shunt) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().with((ServiceInstanceListSupplierBuilder.DelegateCreator)new ShuntDelegateCreator()).build(context);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Shunt.class})
    @ConditionalOnBlockingDiscoveryEnabled
    public static class BlockingSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        public ServiceInstanceListSupplier shuntDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context, Shunt shunt) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().with((ServiceInstanceListSupplierBuilder.DelegateCreator)new ShuntDelegateCreator()).build(context);
        }
    }
}

