/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.shunt;

import org.beast.propagation.PropagationAutoConfiguration;
import org.beast.propagation.context.CurrentContext;
import org.beast.propagation.shunt.Shunt;
import org.beast.propagation.shunt.ShuntProperties;
import org.beast.propagation.shunt.propagation.CurrentShuntContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CurrentContext.class})
@AutoConfigureAfter(value={PropagationAutoConfiguration.class})
@EnableConfigurationProperties(value={ShuntProperties.class})
public class ShuntAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ShuntAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public CurrentShuntContext currentShuntContext(CurrentContext currentContext) {
        return new CurrentShuntContext(currentContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public Shunt shunt(CurrentShuntContext currentShuntContext) {
        Shunt.ShuntBuilder builder = Shunt.builder().currentShuntContext(currentShuntContext);
        return builder.build();
    }
}

