package org.beast.propagation.shunt.loadbalancer;

import lombok.extern.slf4j.Slf4j;
import org.beast.propagation.shunt.Shunt;
import org.beast.propagation.shunt.propagation.ShuntContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

import java.util.*;

/**
 * 分流偏好服务实例提供
 */
@Slf4j
public class ShuntPreferenceServiceInstanceListSupplier extends DelegatingServiceInstanceListSupplier {

//    private final static String GROUP = "group";

    private Shunt shunt;

    public ShuntPreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, Shunt shunt) {
        super(delegate);
        this.shunt = shunt;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        //TODO 这边之后要慢慢放弃，应该走request判断
        return getDelegate().get().map((instances) -> {
            return filter(shunt, instances);
        });
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        return this.get();
    }



    private final static String GROUP = "group";

    public static List<ServiceInstance> filter(Shunt shunt, List<ServiceInstance> serviceInstances) {
        ShuntContext context = shunt.currentShuntContext().get();
        List<String> sequences = Collections.emptyList();
        if (context != null) {
            sequences = context.sequences();
        }
        List<ServiceInstance> filteredInstances = new ArrayList<>();
        if (!CollectionUtils.isEmpty(sequences)) {
            // if the sequence is set
            for (String sequence : sequences) {
                for (ServiceInstance serviceInstance : serviceInstances) {
                    String group = group(serviceInstance);
                    if (sequence.equals(group)) {
                        filteredInstances.add(serviceInstance);
                    }
                }
                if (filteredInstances.size() > 0) {
                    break;
                }
            }

        }

        if (ObjectUtils.isEmpty(filteredInstances)) {
            for (ServiceInstance serviceInstance : serviceInstances) {
                String serverGroup = group(serviceInstance);
                if ("standard".equals(serverGroup) || Objects.isNull(serverGroup)) {
                    filteredInstances.add(serviceInstance);
                }
            }
        }
        log.trace("shunt sequences: {} instances: {}", sequences, filteredInstances);
        return filteredInstances;
    }

    private static String group(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        if (metadata != null) {
            return metadata.get(GROUP);
        }
        return null;
    }

}
