package org.beast.propagation.shunt;


import org.beast.propagation.shunt.loadbalancer.ShuntLoadBalancerClientConfiguration;
import org.beast.propagation.shunt.loadbalancer.ShuntPreferenceServiceInstanceListSupplier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.context.annotation.Configuration;

/**
 * ribbon client 会使用多个 defaultConfiguration
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties
@ConditionalOnBean(Shunt.class)
@AutoConfigureAfter({ShuntAutoConfiguration.class})
@LoadBalancerClients(defaultConfiguration = ShuntLoadBalancerClientConfiguration.class)
public class ShuntLoadBalancerClientAutoConfiguration {
}
