/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.shunt.loadbalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beast.propagation.shunt.Shunt;
import org.beast.propagation.shunt.propagation.ShuntContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class ShuntPreferenceServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private static final String GROUP = "group";
    private Shunt shunt;

    public ShuntPreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, Shunt shunt) {
        super(delegate);
        this.shunt = shunt;
    }

    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.getDelegate().get()).map(this::filteredByShunt);
    }

    public Flux<List<ServiceInstance>> get(Request request) {
        return this.get();
    }

    private List<ServiceInstance> filteredByShunt(List<ServiceInstance> serviceInstances) {
        ShuntContext context = this.shunt.currentShuntContext().get();
        List<Object> sequences = Collections.emptyList();
        if (context != null) {
            sequences = context.sequences();
        }
        ArrayList<ServiceInstance> filteredInstances = new ArrayList<ServiceInstance>();
        if (!CollectionUtils.isEmpty(sequences)) {
            for (String string : sequences) {
                for (ServiceInstance serviceInstance : serviceInstances) {
                    String serverGroup = this.getGroup(serviceInstance);
                    if (!string.equals(serverGroup)) continue;
                    filteredInstances.add(serviceInstance);
                }
                if (filteredInstances.size() <= 0) continue;
                return filteredInstances;
            }
        }
        for (ServiceInstance serviceInstance : serviceInstances) {
            String serverGroup = this.getGroup(serviceInstance);
            if (!"standard".equals(serverGroup) && serverGroup != null) continue;
            filteredInstances.add(serviceInstance);
        }
        return filteredInstances;
    }

    private String getGroup(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null) {
            return (String)metadata.get(GROUP);
        }
        return null;
    }
}

