package org.beast.propagation.shunt.loadbalancer;

import org.beast.propagation.shunt.Shunt;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.DiscoveryClientServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
@ConditionalOnDiscoveryEnabled
public class ShuntLoadBalancerClientConfiguration {


    @Bean
    @ConditionalOnBean(ReactiveDiscoveryClient.class)
    @ConditionalOnMissingBean
    public ServiceInstanceListSupplier shuntDiscoveryClientServiceInstanceListSupplier(
            ConfigurableApplicationContext context,
            Shunt shunt
    ) {
        DiscoveryClient discoveryClient = context.getBean(DiscoveryClient.class);

        ServiceInstanceListSupplier baseSupplier = new DiscoveryClientServiceInstanceListSupplier(discoveryClient, context.getEnvironment());
        baseSupplier = new ShuntPreferenceServiceInstanceListSupplier(baseSupplier, shunt);
        return ServiceInstanceListSupplier.builder()
                .withBase(baseSupplier)
                .withCaching()
                .build(context);
    }

}
