/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.shunt.loadbalancer;

import org.beast.propagation.shunt.Shunt;
import org.beast.propagation.shunt.loadbalancer.ShuntPreferenceServiceInstanceListSupplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.DiscoveryClientServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
public class ShuntLoadBalancerClientConfiguration {
    @Bean
    @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
    @ConditionalOnMissingBean
    public ServiceInstanceListSupplier shuntDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context, Shunt shunt) {
        DiscoveryClient discoveryClient = (DiscoveryClient)context.getBean(DiscoveryClient.class);
        Object baseSupplier = new DiscoveryClientServiceInstanceListSupplier(discoveryClient, (Environment)context.getEnvironment());
        baseSupplier = new ShuntPreferenceServiceInstanceListSupplier((ServiceInstanceListSupplier)baseSupplier, shunt);
        return ServiceInstanceListSupplier.builder().withBase((ServiceInstanceListSupplier)baseSupplier).withCaching().build(context);
    }
}

