/*
 * Decompiled with CFR 0.152.
 */
package org.beast.promotion.web.resolver;

import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.beast.promotion.Tracking;
import org.beast.promotion.web.annotation.GTrackingValue;
import org.beast.promotion.web.exception.MissingTrackingException;
import org.beast.promotion.web.resolver.TrackingWebExtractor;
import org.beast.web.resolver.AbstractArgumentResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;

public class TrackingArgumentResolver
extends AbstractArgumentResolver<GTrackingValue> {
    private static final Logger log = LoggerFactory.getLogger(TrackingArgumentResolver.class);
    private TrackingWebExtractor extractor = new TrackingWebExtractor();

    public TrackingArgumentResolver() {
        super(GTrackingValue.class);
    }

    public boolean isRequired(GTrackingValue annotation) {
        return annotation.required();
    }

    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new MissingTrackingException("g-tracking is required");
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter.getParameter(), GTrackingValue.class);
    }

    public GTrackingValue resolveAnnotation(MethodParameter parameter) {
        return (GTrackingValue)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)parameter.getParameter(), GTrackingValue.class);
    }

    protected Object resolveValue(GTrackingValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        Tracking tracking = this.extractor.extract(parameter, webRequest);
        if (Objects.isNull(tracking)) {
            return null;
        }
        return tracking;
    }
}

