package org.beast.promotion.web.resolver;

import org.beast.web.resolver.CompositeValueWebExtractor;
import org.beast.web.resolver.CookieValueWebExtractor;
import org.beast.web.resolver.HeaderValueWebExtractor;
import org.beast.web.resolver.WebExtractor;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

import javax.servlet.http.HttpServletRequest;

public class TrackingWebExtractor implements WebExtractor<String> {
    public static final String HEADER_NAME = "P-Tracking";
    public static final String COOKIE_NAME = "p-tracking";

    private WebExtractor<String> tackingStringWebExtractor;

    public TrackingWebExtractor() {
        this.tackingStringWebExtractor = CompositeValueWebExtractor.of(
                new HeaderValueWebExtractor(HEADER_NAME),
                new CookieValueWebExtractor(COOKIE_NAME)
        );
    }

    @Override
    public String extract(MethodParameter parameter, NativeWebRequest webRequest) {
        return this.tackingStringWebExtractor.extract(parameter, webRequest);
    }

    @Override
    public String extract(HttpServletRequest servletRequest) {
        return this.tackingStringWebExtractor.extract(servletRequest);
    }
}
