package org.beast.promotion.web.resolver;

import lombok.extern.slf4j.Slf4j;
import org.beast.promotion.web.annotation.GTrackingValue;
import org.beast.promotion.web.exception.MissingTrackingException;
import org.beast.web.resolver.AbstractArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.NativeWebRequest;
import java.util.Objects;

@Slf4j
public class TrackingArgumentResolver extends AbstractArgumentResolver<GTrackingValue> {

    private TrackingWebExtractor extractor = new TrackingWebExtractor();

    public TrackingArgumentResolver() {
        super(GTrackingValue.class);
    }

    @Override
    public boolean isRequired(GTrackingValue annotation) {
        return annotation.required();
    }



    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new MissingTrackingException("g-tracking is required");
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.hasAnnotation(parameter.getParameter(), GTrackingValue.class);
    }

    @Override
    public GTrackingValue resolveAnnotation(MethodParameter parameter) {
        return AnnotatedElementUtils.findMergedAnnotation(parameter.getParameter(), GTrackingValue.class);
    }

    @Override
    protected Object resolveValue(GTrackingValue annotation, MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        String gid = extractor.extract(parameter, webRequest);
        if (Objects.isNull(gid)) {
            return null;
        }
        return gid;
    }

}
