package org.beast.promotion.tracking;


import org.beast.data.message.ReturnResult;
import org.beast.promotion.data.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient("beast-promotion-server")
public interface TrackingClient {


    @PostMapping("/app/api/tracking")
    public ReturnResult<GTracking> tracking(
            @RequestHeader("X-App") String appid,
            @RequestBody CreateTracking input
    );

    @GetMapping("/app/api/tracking/{gid}/advert")
    public ReturnResult<Advert> advert(
            @RequestHeader("X-App") String appid,
            @PathVariable String gid
    );

    @PostMapping("/app/api/tracking/{gid}/advert")
    public ReturnResult<Advert> advert(
            @RequestHeader("X-App") String appid,
            @PathVariable String gid,
            @RequestBody AdvertInput input
    );

    @PostMapping("/app/api/tracking/{gid}/config")
    public ReturnResult<?> tag(
            @RequestHeader("X-App") String appid,
            @PathVariable String gid,
            @RequestBody ConfigInput input
    );

    @PostMapping("/app/api/tracking/{gid}/event")
    public ReturnResult<?> event(
            @RequestHeader("X-App") String appid,
            @PathVariable String gid,
            @RequestBody TrackingEventInput input
    );
}
