package org.beast.promotion.tracking;

import lombok.extern.slf4j.Slf4j;
import org.beast.promotion.data.*;
import org.springframework.lang.Nullable;

import java.util.Map;

@Slf4j
public class PromotionTracking {

    private TrackingClient client;

    private String appid;

    public PromotionTracking(String appid, TrackingClient client) {
        this.appid = appid;
        this.client = client;
    }

    public GTracking tracking(CreateTracking input) {
        return client.tracking(appid, input).orElseThrow();
    }

    public void event(String gid, TrackingEventInput input) {
        var result = client.event(appid, gid, input);
        if (result.isError()) {
            log.warn("tracking gid:{} event: {} exception: {}", gid, input, result.getError());
        }
    }

    public void tag(String gid, ConfigInput tags) {
        var result = client.tag(appid, gid, tags);
        if (result.isError()) {
            log.warn("tracking gid:{} tag: {} exception: {}", gid, tags, result.getError());
        }
    }

    @Nullable
    public Advert advert(String gid) {
        var result = client.advert(appid, gid);
        if (result.isError()) {
            log.warn("tracking gid:{} exception: {}", gid, result.getError());
            return null;
        }
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }
    @Nullable
    public Advert advert(String gid, AdvertInput input) {
        var result = client.advert(appid, gid, input);
        if (result.isError()) {
            log.warn("tracking gid:{} advert: {} exception: {}", gid, input, result.getError());
            return null;
        }
        if (result.isPresent()) {
            return result.get();
        }
        return null;
    }
}
