package org.beast.payment.core.convert;


import org.beast.payment.core.PaymentSymbol;
import org.beast.payment.core.PaymentType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

import java.util.ArrayList;
import java.util.List;

public class PaymentConverters {

    private PaymentConverters() {

    }

    public static List<?> getConvertersToRegister() {
        List<Object> converts = new ArrayList<>();
        converts.add(StringToPaymentSymbolConvert.INSTANCE);
        converts.add(PaymentSymbolToStringConvert.INSTANCE);
        converts.add(StringToPaymentTypeConvert.INSTANCE);
        converts.add(PaymentTypeToStringConvert.INSTANCE);
        return converts;
    }

    static enum StringToPaymentSymbolConvert implements Converter<String, PaymentSymbol> {
        INSTANCE;

        @Override
        public PaymentSymbol convert(@Nullable String source) {
            return source == null ? null : new PaymentSymbol(source);
        }
    }

    static enum PaymentSymbolToStringConvert implements Converter<PaymentSymbol, String> {
        INSTANCE;

        @Override
        public String convert(@Nullable PaymentSymbol source) {
            return source == null ? null : source.toString();
        }
    }

    static enum StringToPaymentTypeConvert implements Converter<String, PaymentType> {
        INSTANCE;

        @Override
        public PaymentType convert(@Nullable String source) {
            return source == null ? null : PaymentType.valueOf(source);
        }
    }
    static enum PaymentTypeToStringConvert implements Converter<PaymentType, String> {
        INSTANCE;

        @Override
        public String convert(@Nullable PaymentType source) {
            return source == null ? null : source.toString();
        }
    }
}
