package org.beast.payment.core.configuration;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.beast.payment.core.PaymentSymbol;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;

@AutoConfigureBefore(JacksonAutoConfiguration.class)
@Configuration
public class PaymentAutoConfiguration {
    @Bean
    public PaymentModule paymentModule() {
        return new PaymentModule();
    }

//    @Bean
//    public MongoModule mongoModule() {
//        return new MongoModule();
//    }


    public static class PaymentModule extends SimpleModule {

        public PaymentModule() {
            super("Payment", Version.unknownVersion());
            this.addSerializer(PaymentSymbol.class, new ToStringSerializer(PaymentSymbol.class));
            this.addDeserializer(PaymentSymbol.class, new PaymentSymbolDeserializer());
        }

        public static class PaymentSymbolDeserializer extends FromStringDeserializer<PaymentSymbol> {
            PaymentSymbolDeserializer() {
                super(PaymentSymbol.class);
            }

            protected PaymentSymbol _deserialize(String value, DeserializationContext ctxt) throws IOException {
                return new PaymentSymbol(value);
            }
        }
    }
}
