package org.beast.payment.core;

/**
 * 退款状态
 * 若退款失败：如银行卡作废或被冻结。
 * 依旧为EXECUTION, 需要手动操作, 改为其他状态
 */
public enum  RefundStatus {

    WAIT,    //等待，等待调用第三方进行退款

    EXECUTION,  //执行中， 已发起成功，退款处理中

    SUCCESS,   //退款成功

    CLOSED,   //退款已关闭


    //其他错误，避免一直重试

}
