package org.beast.payment.core;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Iterator;


public record PaymentType(PayMethod method, String mode) {

    static final String PART_DIVIDER_TOKEN = ":";


    public static PaymentType valueOf(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("string cannot be empty");
        }
        Iterable<String> parts = Splitter.on(PART_DIVIDER_TOKEN).split(value);
        Iterator<String> partsIter = parts.iterator();
        PayMethod method = PayMethod.valueOf(partsIter.next());
        String mode = partsIter.next();

        return new PaymentType(method, mode);
    }

    @Override
    public String toString() {
        return method + PART_DIVIDER_TOKEN + this.mode;
    }
}
