package org.beast.payment.core;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Optional;

@Getter @Setter
@Slf4j
public class App {


    private String appId;

    //路由
    private List<PayRoute> routes;

    public String lookup(PayMethod payMethod, String payMode) {
        Optional<PayRoute> routeOptional = routes.stream().filter(route -> {
            return route.allow(payMethod, payMode);
        }).findFirst();
        if (routeOptional.isEmpty()) {
            return null;
        }
        PayRoute route = routeOptional.get();
        return route.getChannelId();
    }
    public String lookup(PaymentType type) {
        return this.lookup(type.method(), type.mode());
    }

    public String appId() {
        return this.appId;
    }

    public boolean own(Apped apped) {
        return this.appId.equals(apped.getAppId());
    }

}
