/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.core;

import java.util.List;
import java.util.Optional;
import org.beast.payment.core.PayMethod;
import org.beast.payment.core.PayRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger log = LoggerFactory.getLogger(App.class);
    private String appId;
    private List<PayRoute> routes;

    public String lookup(PayMethod payMethod, String payMode) {
        Optional<PayRoute> routeOptional = this.routes.stream().filter(route -> route.allow(payMethod, payMode)).findFirst();
        if (routeOptional.isEmpty()) {
            return null;
        }
        PayRoute route2 = routeOptional.get();
        return route2.getChannelId();
    }

    public String getAppId() {
        return this.appId;
    }

    public List<PayRoute> getRoutes() {
        return this.routes;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setRoutes(List<PayRoute> routes) {
        this.routes = routes;
    }
}

