/*
 * Decompiled with CFR 0.152.
 */
package org.beast.payment.core.configuration;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import org.beast.payment.core.PaymentSymbol;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
@Configuration
public class PaymentAutoConfiguration {
    @Bean
    public PaymentModule paymentModule() {
        return new PaymentModule();
    }

    public static class PaymentModule
    extends SimpleModule {
        public PaymentModule() {
            super("Payment", Version.unknownVersion());
            this.addSerializer(PaymentSymbol.class, (JsonSerializer)new ToStringSerializer(PaymentSymbol.class));
            this.addDeserializer(PaymentSymbol.class, (JsonDeserializer)new PaymentSymbolDeserializer());
        }

        public static class PaymentSymbolDeserializer
        extends FromStringDeserializer<PaymentSymbol> {
            PaymentSymbolDeserializer() {
                super(PaymentSymbol.class);
            }

            protected PaymentSymbol _deserialize(String value, DeserializationContext ctxt) throws IOException {
                return new PaymentSymbol(value);
            }
        }
    }
}

