package org.beast.payment.channel.wechatv3.model;

import lombok.Data;

import java.time.Instant;

/**
 * https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_5_5.shtml
 */
@Data
public class WechatPayNotify {

    private String id;

    private Instant createTime;
    private String resourceType;
    private String eventType;

    private String summary;

    private Resource resource;



    @Data
    public static class Resource {
        //原始类型
        private String originalType;
        //加密算法类型
        private String algorithm;
        //数据密文
        private String ciphertext;
        //附加数据
        private String associatedData;
        //随机串
        private String nonce;
    }
}
