package org.beast.payment.channel.wechatv3.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;

@Data
public class Transaction {

    //公众号场景下，需使用应用属性为公众号的APPID
    @JsonProperty("appid")
    private String appId;

    //直连商户的商户号
    @JsonProperty("mchid")
    private String mchId;


    private String outTradeNo;

    private String transactionId;

    private WechatTradeType tradeType;

    private WechatTradeState tradeState;

    private String tradeStateDesc;

    private String bankType;

    private String attach;

    private Instant successTime;

    private Payer payer;
    private Amount amount;
    private SceneInfo sceneInfo;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Payer {
        @JsonProperty("openid")
        private String openId;
    }

    @Data
    public static class Amount {
        private Integer total;
        private Integer payerTotal;
        private String currency;
        private String payerCurrency;

        public static Amount valueOf(int total) {
            Amount output = new Amount();
            output.setTotal(total);
            return output;
        }
    }

    @Data
    private static class SceneInfo {
        private String deviceId;
    }

}
