package org.beast.payment.channel.wechatv3.api;

import com.google.common.base.MoreObjects;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.ObjectUtils;

@Getter
@Setter
public class ErrorMessage {

    private String code;

    private String message;

    private ErrorDetail detail;


    public boolean isError() {
        return !ObjectUtils.isEmpty(code);
    }
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("code", code)
                .add("message", message)
                .add("detail", detail)
                .toString();
    }

    @Data
    public static class ErrorDetail {
        private String field;
        private String value;
        private String issue;
        private String location;
    }
}
