package org.beast.payment.channel.wechatv3.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

@Data
public class Certificates {

    private List<CertificateItem> data = new ArrayList<>();

    @Data
    public static class CertificateItem {

        private String serialNo;

        private OffsetDateTime effectiveTime;

        private OffsetDateTime expireTime;

        private EncryptedCertificateItem encryptCertificate;
    }

    @Data
    public static class EncryptedCertificateItem {
        private String algorithm;

        private String nonce;

        private String associatedData;

        private String ciphertext;
    }
}
