package org.beast.payment.channel.wechatv3;

import com.wechat.pay.contrib.apache.httpclient.auth.Signer;

import java.nio.charset.StandardCharsets;
import java.security.*;
import java.util.Base64;

public class WechatPrivateKeySigner {
    protected final PrivateKey privateKey;

    public WechatPrivateKeySigner(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String sign(String content) {
        try {
            byte[] message = content.getBytes(StandardCharsets.UTF_8);
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(privateKey);
            sign.update(message);
            return Base64.getEncoder().encodeToString(sign.sign());
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("当前Java环境不支持SHA256withRSA", e);
        } catch (SignatureException e) {
            throw new RuntimeException("签名计算失败", e);
        } catch (InvalidKeyException e) {
            throw new RuntimeException("无效的私钥", e);
        }
    }
}
