package org.beast.payment.channel.wechat.model;

import org.beast.payment.channel.wechat.api.model.CreateUnifiedOrderRequest;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.BeanUtils;

/**
 * 商户系统先调用该接口在微信支付服务后台生成预支付交易单，
 * 返回正确的预支付交易会话标识后再按Native、JSAPI、APP等不同场景生成交易串调起支付。
 */
@Getter @Setter
public class CreateUnifiedOrder {

    private String body;

    private String detail;

    private String outTradeNo;


    private int totalFee;

    private String spbillCreateIp;

    private String notifyUrl;


    private String tradeType;

    private String sceneInfo;

    private String openid;

    private String timeExpire;

    public CreateUnifiedOrderRequest toRequest() {
        CreateUnifiedOrderRequest request = new CreateUnifiedOrderRequest();
        BeanUtils.copyProperties(this, request);
        return request;
    }

}
