package org.beast.payment.channel.wechat.api.model;

import com.google.common.base.MoreObjects;
import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@Getter @Setter
public class ReturnMessage {

    @XmlElement(name = "return_code")
    private String returnCode;

    @XmlElement(name = "return_msg")
    private String returnMsg;

    @XmlElement(name = "retmsg")
    private String retMsg;
    @XmlElement(name = "retcode")
    private String retCode;


    public boolean hasError() {
        return "FAIL".equals(returnCode);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("returnCode", returnCode)
                .add("returnMsg", returnMsg)
                .add("retCode", retCode)
                .add("retMsg", retMsg)
                .toString();
    }

    @XmlTransient
    public String getReturnCode() {
        return returnCode;
    }

    @XmlTransient
    public String getReturnMsg() {
        return returnMsg;
    }

    @XmlTransient
    public String getRetMsg() {
        return retMsg;
    }

    @XmlTransient
    public String getRetCode() {
        return retCode;
    }
}
