package org.beast.payment.channel.wechat.api.model;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement()
@ToString
@Getter
@Setter
public class PayRefundQueryResponse extends ReturnMessage {

    @XmlElement(name = "result_code")
    private String resultCode;

    @XmlElement(name = "err_code")
    private String errCode;

    @XmlElement(name = "err_code_des")
    private String errCodeDes;

    @XmlElement(name = "refund_id")
    private String refundId;

    @XmlElement(name = "out_refund_no")
    private String outRefundNo;

    @XmlElement(name = "total_fee")
    private int totalFee;

    @XmlElement(name = "settlement_total_fee")
    private int settlementTotalFee;

    @XmlElement(name = "refund_fee")
    private int refundFee;

    @XmlTransient
    public String getResultCode() {
        return resultCode;
    }

    @XmlTransient
    public String getErrCode() {
        return errCode;
    }

    @XmlTransient
    public String getErrCodeDes() {
        return errCodeDes;
    }

    @XmlTransient
    public String getRefundId() {
        return refundId;
    }

    @XmlTransient
    public String getOutRefundNo() {
        return outRefundNo;
    }

    @XmlTransient
    public int getTotalFee() {
        return totalFee;
    }

    @XmlTransient
    public int getSettlementTotalFee() {
        return settlementTotalFee;
    }

    @XmlTransient
    public int getRefundFee() {
        return refundFee;
    }
}
