package org.beast.payment.channel.wechat.api.model;

import com.google.common.base.MoreObjects;
import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name = "xml")
@Getter @Setter
public class CreateUnifiedOrderResponse extends ReturnMessage {

    @XmlElement(name = "result_code")
    private String resultCode;

//    @XmlElement(name = "return_msg")
//    private String returnMsg;

    @XmlElement(name = "err_code")
    private String errCode;

    @XmlElement(name = "err_code_des")
    private String errCodeDes;


    //调用接口提交的: 公众账号ID
    @XmlElement(name = "appid")
    private String appId;

    //调用接口提交的: 设备号
    @XmlElement(name = "device_info")
    private String deviceInfo;


    //调用接口提交的: 商户号
    @XmlElement(name = "mch_id")
    private String mchId;


    //调用接口提交的: 随机字符串
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    //调用接口提交的: 签名
    private String sign;


    /**
     * JSAPI
     * NATIVE
     * APP
     */
    @XmlElement(name = "trade_type")
    private String tradeType;

    /**
     * 预支付交易会话标识
     * @value wx201410272009395522657a690389285100
     */
    @XmlElement(name = "prepay_id")
    private String prepayId;


    /**
     *
     */
    @XmlElement(name = "mweb_url")
    private String mwebUrl;

    /**
     * trade_type=NATIVE时有返回，此url用于生成支付二维码，然后提供给用户进行扫码支付。
     * @value weixin://wxpay/bizpayurl/up?pr=NwY5Mz9&groupid=00
     */
    @XmlElement(name = "code_url")
    private String codeUrl;



    public boolean isCreateSuccess() {
        return "SUCCESS".equals(this.resultCode);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("appId", appId)
                .add("deviceInfo", deviceInfo)
                .add("mchId", mchId)
                .add("nonceStr", nonceStr)
                .add("sign", sign)
                .add("resultCode", resultCode)
                .add("errCode", errCode)
                .add("errCodeDes", errCodeDes)
                .add("tradeType", tradeType)
                .add("prepayId", prepayId)
                .add("mwebUrl", mwebUrl)
                .toString();
    }

    @XmlTransient
    public String getResultCode() {
        return resultCode;
    }

    @XmlTransient
    public String getErrCode() {
        return errCode;
    }

    @XmlTransient
    public String getErrCodeDes() {
        return errCodeDes;
    }

    @XmlTransient
    public String getAppId() {
        return appId;
    }

    @XmlTransient
    public String getDeviceInfo() {
        return deviceInfo;
    }

    @XmlTransient
    public String getMchId() {
        return mchId;
    }

    @XmlTransient
    public String getNonceStr() {
        return nonceStr;
    }

    @XmlTransient
    public String getSign() {
        return sign;
    }

    @XmlTransient
    public String getTradeType() {
        return tradeType;
    }

    @XmlTransient
    public String getPrepayId() {
        return prepayId;
    }

    @XmlTransient
    public String getMwebUrl() {
        return mwebUrl;
    }

    @XmlTransient
    public String getCodeUrl() {
        return codeUrl;
    }
}
