package org.beast.payment.channel.wechat.api.model;

import com.google.common.collect.Maps;
import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@XmlRootElement(name = "xml")
@Getter @Setter
public class CreateUnifiedOrderRequest extends BaseRequest {


    //option: 设备号
    @XmlElement(name = "device_info")
    private String deviceInfo;



    //商品描述:注意使用格式. https://pay.weixin.qq.com/wiki/doc/api/H5.php?chapter=4_2
    @XmlElement(name = "body")
    private String body;

    //option: 详情
    @XmlElement(name = "detail")
    private String detail;

    //option: 附加数据
    @XmlElement(name = "attach")
    private String attach;

    //
    @XmlElement(name = "out_trade_no")
    private String outTradeNo;


    //option: 货币类型
    @XmlElement(name = "fee_type")
    private String feeType;

    //单位分
    @XmlElement(name = "total_fee")
    private int totalFee;

    //终端IP
    @XmlElement(name = "spbill_create_ip")
    private String spbillCreateIp;

    //option：
    @XmlElement(name = "time_start")
    private String timeStart;

    //option:交易结束时间
    @XmlElement(name = "time_expire")
    private String timeExpire;

    //option:
    @XmlElement(name = "goods_tag")
    private String goodsTag;

    //通知地址
    @XmlElement(name = "notify_url")
    private String notifyUrl;


    @XmlElement(name = "trade_type")
    private String tradeType;

    //option:
    @XmlElement(name = "product_id")
    private String productId;

    //option:
    @XmlElement(name = "limit_pay")
    private String limitPay;

    //option:
    @XmlElement(name = "openid")
    private String openid;

    //option:
    @XmlElement(name = "receipt")
    private String receipt;

    //场景信息
    @XmlElement(name = "scene_info")
    private String sceneInfo;


    public Map<String, String> getSignParams() {
        Map<String, String> params = Maps.newHashMap(super.getSignParams());
        params.put("device_info", deviceInfo);
        params.put("body", body);
        params.put("detail", detail);
        params.put("attach", attach);
        params.put("out_trade_no", outTradeNo);
        params.put("fee_type", feeType);
        params.put("total_fee", String.valueOf(totalFee));
        params.put("spbill_create_ip", this.spbillCreateIp);
        params.put("time_start", timeStart);
        params.put("time_expire", timeExpire);
        params.put("goods_tag", goodsTag);
        params.put("notify_url", notifyUrl);
        params.put("trade_type", tradeType);
        params.put("product_id", productId);
        params.put("limit_pay", limitPay);
        params.put("openid", openid);
        params.put("receipt", receipt);
        params.put("sceneInfo", sceneInfo);
        return params.entrySet().stream().filter(item -> Objects.nonNull(item.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @XmlTransient
    public String getDeviceInfo() {
        return deviceInfo;
    }

    @XmlTransient
    public String getBody() {
        return body;
    }

    @XmlTransient
    public String getDetail() {
        return detail;
    }

    @XmlTransient
    public String getAttach() {
        return attach;
    }

    @XmlTransient
    public String getOutTradeNo() {
        return outTradeNo;
    }

    @XmlTransient
    public String getFeeType() {
        return feeType;
    }

    @XmlTransient
    public int getTotalFee() {
        return totalFee;
    }

    @XmlTransient
    public String getSpbillCreateIp() {
        return spbillCreateIp;
    }

    @XmlTransient
    public String getTimeStart() {
        return timeStart;
    }

    @XmlTransient
    public String getTimeExpire() {
        return timeExpire;
    }

    @XmlTransient
    public String getGoodsTag() {
        return goodsTag;
    }

    @XmlTransient
    public String getNotifyUrl() {
        return notifyUrl;
    }

    @XmlTransient
    public String getTradeType() {
        return tradeType;
    }

    @XmlTransient
    public String getProductId() {
        return productId;
    }

    @XmlTransient
    public String getLimitPay() {
        return limitPay;
    }

    @XmlTransient
    public String getOpenid() {
        return openid;
    }

    @XmlTransient
    public String getReceipt() {
        return receipt;
    }

    @XmlTransient
    public String getSceneInfo() {
        return sceneInfo;
    }
}
