package org.beast.payment.channel.wechat.api;

import org.beast.payment.channel.wechat.api.model.*;
import org.springframework.web.bind.annotation.PostMapping;

public interface WechatPayHttpClient {

    /**
     * 统一下单
     * @link https://pay.weixin.qq.com/wiki/doc/api/H5.php?chapter=9_20&index=1
     */
    @PostMapping("/pay/unifiedorder")
    CreateUnifiedOrderResponse createUnifiedOrder(CreateUnifiedOrderRequest unifiedOrder);


    /**
     * 申请退款
     * @link https://pay.weixin.qq.com/wiki/doc/api/H5.php?chapter=9_4&index=4
     */
    @PostMapping("/secapi/pay/refund")
    PayRefundResponse refund(PayRefundRequest payRefund);

    /**
     * 查询退款
     * @link https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_5
     */
    @PostMapping("/pay/refundquery")
    PayRefundQueryResponse queryRefund(PayRefundQueryRequest request);


}
