package org.beast.payment.channel.wechat;


import org.beast.payment.channel.AbstractClientFactory;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

public class WechatPayV2ClientFactory extends AbstractClientFactory<WechatPayV2Client, WechatPayV2ClientFactory.Config> {

    public static final WechatSignType SIGN_TYPE = WechatSignType.MD5;

    public static final String SANDBOX_TARGET = "https://api.mch.weixin.qq.com/sandboxnew/";
    public static final String TARGET = "https://api.mch.weixin.qq.com";



    public WechatPayV2ClientFactory() {

    }

    public WechatPayV2Client newClient(Config config) {
        WechatPayV2Client client = new WechatPayV2Client(config.endpoint);
        client.setAppId(config.appId);
        client.setKey(config.key);
        client.setMchId(config.mchId);
        return client;
    }

    public static final String APP_ID_NAME = "appId";
    public static final String KEY_NAME = "key";
    public static final String DOMAIN_NAME = "domain";
    @Getter
    @Setter
    public static class Config {


        @NotBlank
        private String endpoint;

        @NotBlank
        private String appId;

        @NotBlank
        private String key;

        @NotBlank
        private String mchId;

        @NotBlank
        private String domain;

    }

}
