package org.beast.payment.channel.wechat;


import org.beast.payment.channel.wechat.api.WechatPayHttpClient;
import org.beast.payment.channel.wechat.api.model.*;
import feign.Feign;
import feign.jaxb.JAXBContextFactory;
import feign.jaxb.JAXBDecoder;
import feign.jaxb.JAXBEncoder;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

import javax.xml.bind.JAXBException;
import java.util.Map;

public class WechatPayV2Client {

    private String appId;

    private String mchId;

    private String key;


    private WechatPayHttpClient client;

    private WechatSignType signType = WechatSignType.MD5;

    public WechatPayV2Client(String endpoint) {
        JAXBContextFactory jaxbFactory = new JAXBContextFactory.Builder().build();
        this.client = Feign.builder()
                .contract(new SpringMvcContract())
                .encoder(new JAXBEncoder(jaxbFactory))
                .decoder(new JAXBDecoder(jaxbFactory))
                .target(WechatPayHttpClient.class, endpoint);
    }

    public void config(BaseRequest request) {
        request.setAppId(appId);
        request.setMchId(mchId);
        //随机字符串
        request.setNonceStr(RandomStringUtils.randomAlphanumeric(16));
        request.setSignType(signType.name());
        Map<String, String> params = request.getSignParams();
        String sign = WechatPayUtils.generateSignature(params, this.key, signType);
        request.setSign(sign);

    }
    public CreateUnifiedOrderResponse createUnifiedOrder(CreateUnifiedOrderRequest request) throws JAXBException {
        config(request);
        return client.createUnifiedOrder(request);
    }

    public PayRefundResponse refund(PayRefundRequest request) {
        config(request);
        return client.refund(request);
    }

    public PayRefundQueryResponse queryRefund(PayRefundQueryRequest request) {
        config(request);
        return client.queryRefund(request);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return appId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    public void setClient(WechatPayHttpClient client) {
        this.client = client;
    }

    public void setSignType(WechatSignType signType) {
        this.signType = signType;
    }

    public WechatSignType getSignType() {
        return signType;
    }
}
