package org.beast.payment.channel.paypal;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.paypal.base.Constants;
import com.paypal.base.rest.APIContext;
import org.beast.payment.channel.AbstractClientFactory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;

import javax.validation.constraints.NotBlank;
import java.util.Map;


public class PayPalClientFactory extends AbstractClientFactory<PayPalClient, PayPalClientFactory.Config> {

    public static final String SANDBOX_MODE = Constants.SANDBOX;
    public static final String MODE = Constants.LIVE;
    public static final String IPN_SANDBOX_ENDPOINT = Constants.IPN_SANDBOX_ENDPOINT;;
    public static final String IPN_ENDPOINT = Constants.IPN_LIVE_ENDPOINT;



    @Value("${spring.profiles.active}")
    private String active;

    @Override
    public PayPalClient newClient(Config config) {

        String clientId = config.getClientId();
        String secret = config.getSecret();
        String mode = config.getMode();
        Map<String, String> configurations = Maps.newHashMap();

        //代理
        //http://api-sandbox-paypal-com.proxy.pingtech.net/
        //http://api-paypal-com.proxy.pingtech.net/
        if (!Strings.isNullOrEmpty(config.getEndpoint())) {
            configurations.put(Constants.ENDPOINT, config.getEndpoint());
        }


        APIContext context = new APIContext(clientId, secret, mode, configurations);
        return new PayPalClient(context);
    }

    public static final String IPN_ENDPOINT_NAME = "ipnEndpoint";

    public static final String DOMAIN_NAME = "domain";

    @Getter @Setter
    public static final class Config {
        @NotBlank
        private String clientId;
        @NotBlank
        private String secret;
        @NotBlank
        private String mode;

        private String endpoint;

        //IPN (回调有依赖)
        @NotBlank
        private String ipnEndpoint;

        @NotBlank
        private String domain;
    }
}
