package org.beast.payment.channel.paypal;


import com.paypal.api.payments.*;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PayPalClient {

    private APIContext context;

    public PayPalClient(APIContext context) {
        this.context = context;
    }

    public APIContext getContext() {
        return context;
    }

    /**
     * 创建交易
     */
    public Payment createPayment(
            String currency,
            BigDecimal total,
            String description,
            String cancelUrl,
            String successUrl
    ) throws PayPalRESTException {
        String intent = "";
        String method = "";
        Amount amount = new Amount();
        amount.setCurrency(currency);
        amount.setTotal(total.toString());

        Transaction transaction = new Transaction();
        transaction.setDescription(description);
        transaction.setAmount(amount);

        List<Transaction> transactions = new ArrayList<>();
        transactions.add(transaction);

        Payer payer = new Payer();
        payer.setPaymentMethod(method);

        Payment payment = new Payment();
        payment.setIntent(intent);
        payment.setPayer(payer);
        payment.setTransactions(transactions);
        RedirectUrls redirectUrls = new RedirectUrls();
        redirectUrls.setCancelUrl(cancelUrl);
        redirectUrls.setReturnUrl(successUrl);
        payment.setRedirectUrls(redirectUrls);
        return payment.create(this.context);
    }

    /**
     * 查询交易
     */
    public Payment getPayment(String paymentId) throws PayPalRESTException {
        return Payment.get(this.context, paymentId);
    }

    /**
     * 交易执行，确保付款进入账户
     */
    public Payment executePayment(String paymentId, String payerId) throws PayPalRESTException {
        Payment payment = new Payment();
        payment.setId(paymentId);
        PaymentExecution paymentExecution = new PaymentExecution();
        paymentExecution.setPayerId(payerId);
        return payment.execute(this.context, paymentExecution);
    }


}
